// CLS_DlgSettingOCD.cpp : ????????
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "CLS_DlgSettingOSD.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "Include\CommonFun.h"
#include "LogManager.h"


// CLS_DlgSettingOCD Ի

IMPLEMENT_DYNAMIC(CLS_DlgSettingOSD, CDialog)

CLS_DlgSettingOSD::CLS_DlgSettingOSD(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_DlgSettingOSD::IDD, pParent)
	, m_iSwichTime(3)
{

}

CLS_DlgSettingOSD::~CLS_DlgSettingOSD()
{
}

void CLS_DlgSettingOSD::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDT_DIAPHANEITY, m_edtDiaphaneity);
	DDX_Control(pDX, IDC_CBO_WORD_SIZE, m_cboWordSize);
	DDX_Control(pDX, IDC_CBO_ALIGN, m_cboAlignAboBelow);
	DDX_Control(pDX, IDC_CBO_DINAMIC, m_cboDinamic);
	DDX_Control(pDX, IDC_EDT_X_COORDINATE, m_edtXCoordinate);
	DDX_Control(pDX, IDC_EDT_Y_COORDINATE, m_edtYCoordinate);
	DDX_Control(pDX, IDC_CBO_CHANNEL_NO, m_cboChannelNo);
	DDX_Control(pDX, IDC_BTN_WORD_SHOW_COLOR, m_btnShowWordColor);
	DDX_Control(pDX, IDC_BTN_BACK_SHOW_COLOR, m_btnShowBackColor);
	DDX_Control(pDX, IDC_EDT_CONTENT, m_edtOSDContent);
	DDX_Control(pDX, IDC_CBO_ALIGN2, m_cboAligeLeftRight);
	DDX_Control(pDX, IDC_EDT_PICTURE_WIDE, m_edtWCoordinate);
	DDX_Control(pDX, IDC_EDT_PICTURE_HIGH, m_edtHCoordinate);
	DDX_Control(pDX, IDC_CHECK_OSD_ENABLE, m_chkOSDEnable);
	DDX_Text(pDX, IDC_EDIT_SWITCHTIME, m_iSwichTime);
	DDV_MinMaxInt(pDX, m_iSwichTime, 0, 3600);
}

void CLS_DlgSettingOSD::Initialize()
{
	LoadDialog();
	UpdateOsd();
}


void CLS_DlgSettingOSD::LoadDialog()
{
// 	InsertString(m_cboAlignAboBelow,0,IDS_CFG_CENTER_OF_LEFT_AND_RIGHT);
// 	InsertString(m_cboAlignAboBelow,1,IDS_CFG_LEFT_JUSTIFYING);
// 	InsertString(m_cboAlignAboBelow,2,IDS_CFG_RIGHT_JUSTIFYING);
// 	InsertString(m_cboAlignAboBelow,3,IDS_CFG_CENTER_OF_UP_AND_DOWN);
// 	InsertString(m_cboAlignAboBelow,4,IDS_CFG_UP_JUSTIFYING);
// 	InsertString(m_cboAlignAboBelow,5,IDS_CFG_DOWN_JUSTFYING);

	m_cboAlignAboBelow.AddString("¾");
	m_cboAlignAboBelow.AddString("϶");
	m_cboAlignAboBelow.AddString("¶");
	m_cboAlignAboBelow.SetCurSel(0);

	m_cboAligeLeftRight.AddString("Ҿ");
	m_cboAligeLeftRight.AddString("");
	m_cboAligeLeftRight.AddString("Ҷ");
	m_cboAligeLeftRight.SetCurSel(0);
// 
// 	InsertString(m_cboDinamic,0,IDS_CFG_STATIC_STATUS_DISPLAY);
// 	InsertString(m_cboDinamic,1,IDS_CFG_LEFT_AND_RIGHT_MOVING_STATUS_DISPLAY);
// 	InsertString(m_cboDinamic,2,IDS_CFG_UP_AND_DOWN_MOVING_STATUS_DISPLAY);

	m_cboDinamic.AddString(GetText(IDS_CFG_STATIC_STATUS_DISPLAY));
	m_cboDinamic.AddString(GetText(IDS_CFG_LEFT_AND_RIGHT_MOVING_STATUS_DISPLAY));
	m_cboDinamic.AddString(GetText(IDS_CFG_UP_AND_DOWN_MOVING_STATUS_DISPLAY));
	m_cboDinamic.AddString(GetTextByLan("̬ʾ","static line status display"));
	m_cboDinamic.SetCurSel(0);
	CString csinsert;
	csinsert.Format("%d",16);
	InsertString(m_cboWordSize,0,csinsert);
	csinsert.Format("%d",24);
	InsertString(m_cboWordSize,1,csinsert);
	csinsert.Format("%d",32);
	InsertString(m_cboWordSize,2,csinsert);
	csinsert.Format("%d",48);
	InsertString(m_cboWordSize,3,csinsert);
	csinsert.Format("%d",64);
	InsertString(m_cboWordSize,4,csinsert);
	int iRet = CreateChannelCombo(m_lLogonID, &m_cboChannelNo);
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::LoadDialog][CreateChannelCombo] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
	}
	m_edtXCoordinate.LimitText(4);
	m_edtYCoordinate.LimitText(4);
	m_edtWCoordinate.LimitText(4);
	m_edtHCoordinate.LimitText(4);

	SetDlgItemText(IDC_CHECK_OSD_ENABLE, GetText(IDS_SETTING_REGSVRENABLE));
}
	
BEGIN_MESSAGE_MAP(CLS_DlgSettingOSD, CDialog)
	ON_BN_CLICKED(IDC_BTN_SET, &CLS_DlgSettingOSD::OnBnClickedBtnSet)
	ON_BN_CLICKED(IDC_BTN_WORD_COLOR, &CLS_DlgSettingOSD::OnBnClickedBtnWordColor)
	ON_BN_CLICKED(IDC_BTN_BACK_COLOR, &CLS_DlgSettingOSD::OnBnClickedBtnBackColor)
	//ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_NO, &CLS_DlgSettingOSD::OnCbnSelchangeCboChannelNo)
	ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_NO, &CLS_DlgSettingOSD::OnCbnSelchangeCboChannelNo)
	ON_CBN_SELCHANGE(IDC_CBO_DINAMIC, &CLS_DlgSettingOSD::OnCbnSelchangeCboDinamic)
END_MESSAGE_MAP()


// CLS_DlgSettingOCD Ϣ
	
void CLS_DlgSettingOSD::OnBnClickedBtnSet()
{
	// TODO: ڴӿؼ֪ͨ
	if (m_lLogonID == -1 )
	{
		return;
	}

	UpdateData(TRUE);

	m_iWordColor &= 0x00FFFFFF;
	m_iBackColor &= 0x00FFFFFF;
	DecOsd tDecOsdInput;
	memset(&tDecOsdInput, 0, sizeof(DecOsd));
	int iRet = -1;
	tDecOsdInput.iSize = sizeof(tDecOsdInput);
	tDecOsdInput.iColor = m_iWordColor;
	tDecOsdInput.iBackColor = m_iBackColor;
	tDecOsdInput.iDiaphaneity = GetDlgItemInt(IDC_EDT_DIAPHANEITY);
	tDecOsdInput.iFontSize = m_cboWordSize.GetCurSel() + 1;
	//tDecOsdInput.iAlign = m_cboAlign.GetCurSel();
	tDecOsdInput.iDynamic = m_cboDinamic.GetCurSel();
	tDecOsdInput.tArea.iX = GetDlgItemInt(IDC_EDT_X_COORDINATE);
	tDecOsdInput.tArea.iY = GetDlgItemInt(IDC_EDT_Y_COORDINATE);
	tDecOsdInput.tArea.iWidth = GetDlgItemInt(IDC_EDT_PICTURE_WIDE);
	tDecOsdInput.tArea.iHeight = GetDlgItemInt(IDC_EDT_PICTURE_HIGH);
	tDecOsdInput.tArea.iBufSize = sizeof(ScreenPara);
	int iSelectChannel = m_cboChannelNo.GetCurSel();
	int iChannel = m_cboChannelNo.GetItemData(iSelectChannel);
// 	int iSelectPos = m_cboPictureNo.GetCurSel();
// 	int iPos = m_cboPictureNo.GetItemData(iSelectPos);
	tDecOsdInput.iAboutBelowAlign = m_cboAlignAboBelow.GetCurSel();
	tDecOsdInput.iLeftRightAlign = m_cboAligeLeftRight.GetCurSel();
	CString cstrOSDContent;
	m_edtOSDContent.GetWindowText(cstrOSDContent);
	strncpy(tDecOsdInput.cOsd, cstrOSDContent.GetBuffer(),sizeof(tDecOsdInput.cOsd) - 1);
	tDecOsdInput.iEnbale = m_chkOSDEnable.GetCheck();
	if(SHOW_STATIC_LINE_DISPLAY==tDecOsdInput.iDynamic)
	{
		tDecOsdInput.iSwitchTime = m_iSwichTime;
	}
	iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannel, 0, CMD_DEC_CFG_DECOSD, &tDecOsdInput, sizeof(DecOsd));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::OnBnClickedBtnSet][DEC_ClientSetDevConfig:CMD_DEC_CFG_DECOSD] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
	}
}
void CLS_DlgSettingOSD::OnBnClickedBtnWordColor()
{
	// TODO: ڴӿؼ֪ͨ
	if (m_lLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_lLogonID);
		return;
	}

	CColorDialog clsColorDlg;
	int iRet = clsColorDlg.DoModal();
	if (IDOK == iRet)
	{
		m_iWordColor = clsColorDlg.GetColor();
		try
		{
			m_btnShowWordColor.RemoveChild(0);
			m_btnShowWordColor.AddChild(0);
			m_btnShowWordColor.SetColor(0,RGB(GetRValue(m_iWordColor), GetGValue(m_iWordColor),GetBValue(m_iWordColor)));
		}
		catch (CException* e)
		{
			e->ReportError();
			e->Delete();
		}
	}
}

void CLS_DlgSettingOSD::OnBnClickedBtnBackColor()
{
	// TODO: ڴӿؼ֪ͨ
	if (m_lLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_lLogonID);
		return;
	}

	CColorDialog clsColorDlg;
	int iRet = clsColorDlg.DoModal();
	if (IDOK == iRet)
	{
		m_iBackColor = clsColorDlg.GetColor();
		try
		{
			m_btnShowBackColor.RemoveChild(0);
			m_btnShowBackColor.AddChild(0);
			m_btnShowBackColor.SetColor(0,RGB(GetRValue(m_iBackColor), GetGValue(m_iBackColor),GetBValue(m_iBackColor)));
		}
		catch (CException* e)
		{
			e->ReportError();
			e->Delete();
		}
	}
}

BOOL CLS_DlgSettingOSD::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ڴӶĳʼ

	m_btnShowBackColor.SetChildNum(0);
	m_btnShowBackColor.SetColor(0,RGB(0,0,0));

	m_btnShowWordColor.SetChildNum(0);
	m_btnShowWordColor.SetColor(0,RGB(0,0,0));

	m_edtOSDContent.SetLimitText(252);


	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

//void CLS_DlgSettingOSD::OnCbnSelchangeCboChannelNo()
//{
//	// TODO: ڴӿؼ֪ͨ
//	int iSelect = m_cboChannelNo.GetCurSel();
//	int iChannelNo = m_cboChannelNo.GetItemData(iSelect);
//	int i = 0;
//	int iPosNum = 0;
//	int iRet = -1;
//	iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannelNo, 0, CMD_DEC_CFG_PICNUM, &iPosNum, sizeof(int));
//	if(iRet < 0)
//	{
//		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::OnCbnSelchangeCboChannelNo][DEC_ClientGetDevConfig:CMD_DEC_CFG_PICNUM] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
//	}
//	BaseOffset tGetStartAddress;
//	iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tGetStartAddress, sizeof(BaseOffset));
//	if(iRet < 0)
//	{
//		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::OnCbnSelchangeCboChannelNo][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
//	}
//	m_cboPictureNo.ResetContent();
//	for (int i = 0; i < iPosNum; ++i)
//	{
//		CString szTemp;
//		szTemp.Format("%d", i+1);
//		m_cboPictureNo.AddString(szTemp);
//	}
//	for(i = 0;i<DEC_MAX_FLOAT_WINDOW_NUM;i++)
//	{
//		CString szTemp;
//		szTemp.Format("%d", i + tGetStartAddress.iFloatWindow);
//		m_cboPictureNo.AddString(szTemp);
//	}
//	m_cboPictureNo.SetCurSel(0);
//}

void CLS_DlgSettingOSD::OnCbnSelchangeCboChannelNo()
{
	// TODO: Add your control notification handler code here
	UpdateOsd();
}

void CLS_DlgSettingOSD::UpdateOsd()
{
	int iChannel = GetComboData(&m_cboChannelNo);//GetDlgItemInt(IDC_CBO_CHANNEL_NO);//m_cboChannelNo.GetCurSel();
	//int iPicture = m_cboPictureNo.GetCurSel();
	DecOsd tDecOsdOutput = {0};
	int iRet = -1;
	iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannel, 0, 
		CMD_DEC_CFG_DECOSD, &tDecOsdOutput, sizeof(DecOsd));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientSetDevConfig:CMD_DEC_CFG_DECOSD] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
		return;
	}

	SetDlgItemInt(IDC_EDT_DIAPHANEITY,tDecOsdOutput.iDiaphaneity);
	m_cboWordSize.SetCurSel(tDecOsdOutput.iFontSize);
	//m_cboAlign.SetCurSel(tDecOsdOutput.iAlign);
	m_cboAlignAboBelow.SetCurSel(tDecOsdOutput.iAboutBelowAlign);
	m_cboAligeLeftRight.SetCurSel(tDecOsdOutput.iLeftRightAlign);
	m_cboDinamic.SetCurSel(tDecOsdOutput.iDynamic);
	SetDlgItemInt(IDC_EDT_X_COORDINATE, tDecOsdOutput.tArea.iX);
	SetDlgItemInt(IDC_EDT_Y_COORDINATE, tDecOsdOutput.tArea.iY);
	SetDlgItemInt(IDC_EDT_PICTURE_WIDE, tDecOsdOutput.tArea.iWidth);
	SetDlgItemInt(IDC_EDT_PICTURE_HIGH, tDecOsdOutput.tArea.iHeight);
	SetDlgItemText(IDC_EDT_CONTENT, tDecOsdOutput.cOsd);
	m_chkOSDEnable.SetCheck(tDecOsdOutput.iEnbale);
	m_iSwichTime = tDecOsdOutput.iSwitchTime;

	m_iWordColor = tDecOsdOutput.iColor;

	if(SHOW_STATIC_LINE_DISPLAY==m_cboDinamic.GetCurSel())
	{
		GetDlgItem(IDC_EDIT_SWITCHTIME)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_SWITCHTIME)->EnableWindow(FALSE);
	}

	UpdateData(FALSE);
	try
	{
		m_btnShowWordColor.RemoveChild(0);
		m_btnShowWordColor.AddChild(0);
		m_btnShowWordColor.SetColor(0,RGB(GetRValue(m_iWordColor), GetGValue(m_iWordColor),GetBValue(m_iWordColor)));
	}
	catch (CException* e)
	{
		e->ReportError();
		e->Delete();
	}


	m_iBackColor = tDecOsdOutput.iBackColor;
	try
	{
		m_btnShowBackColor.RemoveChild(0);
		m_btnShowBackColor.AddChild(0);
		m_btnShowBackColor.SetColor(0,RGB(GetRValue(m_iBackColor), GetGValue(m_iBackColor),GetBValue(m_iBackColor)));
	}
	catch (CException* e)
	{
		e->ReportError();
		e->Delete();
	}
}

void CLS_DlgSettingOSD::OnCbnSelchangeCboDinamic()
{
	// TODO: Add your control notification handler code here
	if(SHOW_STATIC_LINE_DISPLAY==m_cboDinamic.GetCurSel())
	{
		GetDlgItem(IDC_EDIT_SWITCHTIME)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_SWITCHTIME)->EnableWindow(FALSE);
	}
}
